# StreamShield Extension - Installation Guide

## Quick Install (Chrome/Edge/Brave)

### Method 1: Load Unpacked Extension (Developer Mode)

1. **Open Extension Management Page**
   - Chrome: Navigate to `chrome://extensions/`
   - Edge: Navigate to `edge://extensions/`
   - Brave: Navigate to `brave://extensions/`

2. **Enable Developer Mode**
   - Toggle the "Developer mode" switch in the top-right corner

3. **Load the Extension**
   - Click "Load unpacked"
   - Browse to: `E:\BETA!!!\AIAdblocking\extension\chrome`
   - Click "Select Folder"

4. **Verify Installation**
   - You should see "StreamShield - Ultimate Ad Blocker" in your extensions list
   - The extension icon should appear in your browser toolbar
   - Version should show as "3.0.0"

### Method 2: Update Installed Version (If Already Installed)

If you have StreamShield already installed at `C:\Program Files\StreamShield\`:

1. **Copy Updated Files** (Requires Admin)
   ```bash
   # Run Command Prompt as Administrator
   copy "E:\BETA!!!\AIAdblocking\extension\chrome\zoechip-popup-blocker.js" "C:\Program Files\StreamShield\extensions\chrome\"
   copy "E:\BETA!!!\AIAdblocking\extension\chrome\manifest.json" "C:\Program Files\StreamShield\extensions\chrome\"
   ```

2. **Reload Extension**
   - Go to your browser's extension page
   - Find StreamShield
   - Click the refresh/reload icon
   - Or disable and re-enable the extension

## Verify Installation

### Check Extension is Loaded

1. Visit any website (e.g., google.com)
2. Open Browser Console (F12)
3. Look for console messages:
   ```
   StreamShield v4.0 - Enhanced Protection Active
   🛡️ Popup blocker initialized
   🚫 Ad blocker initialized
   🔒 Privacy protector initialized
   ✅ StreamShield fully initialized
   ```

### Test ZoeChip Popup Blocker

1. **Option A: Visit ZoeChip** (Live Test)
   - Go to zoechip.com (or any supported streaming site)
   - Open Console (F12)
   - Look for:
     ```
     🛡️ StreamShield: Aggressive Popup/Redirect Blocker Active
     ✅ Free streaming popup/redirect blocker loaded
     ```

2. **Option B: Use Test Page** (Safe Test)
   - Open `test-popup-blocker.html` in your browser
   - Click the test buttons
   - Verify popups are blocked
   - Check console for blocking messages

## Supported Streaming Sites

The aggressive popup blocker activates on:
- ✅ zoechip.com, zoechip.cc, zoechip.gg
- ✅ fmovies.* (all TLDs)
- ✅ gomovies.* (all TLDs)
- ✅ lookmovie.* (all TLDs)
- ✅ 123movies.* (all TLDs)
- ✅ soap2day.* (all TLDs)
- ✅ putlocker.* (all TLDs)
- ✅ movie4k.* (all TLDs)
- ✅ flixmomo.* (all TLDs)
- ✅ rabbitstream.* (all TLDs)
- ✅ vidstream.* (all TLDs)
- ✅ dokicloud.* (all TLDs)
- ✅ streamtape.* (all TLDs)
- ✅ mixdrop.* (all TLDs)

## Features Enabled

### For All Sites
- ✅ Network-level ad blocking (background.js)
- ✅ DOM-based ad removal (content.js)
- ✅ Privacy protection (anti-fingerprinting)
- ✅ Cookie consent auto-reject
- ✅ Dark mode toggle
- ✅ Tracker blocking

### For YouTube
- ✅ Ad skipper (automatic)
- ✅ SponsorBlock integration
- ✅ Speed up ads to 16x
- ✅ Auto-click skip button

### For Streaming Sites (ZoeChip, etc.)
- ✅ **Ultra-aggressive popup blocking**
- ✅ **Redirect loop prevention**
- ✅ **Fake overlay removal**
- ✅ **onclick handler stripping**
- ✅ **Timer-based popup blocking**
- ✅ **Ad iframe monitoring**
- ✅ **Scroll re-enabling**

## Troubleshooting

### Extension Not Loading
- **Problem:** Extension doesn't appear in toolbar
- **Solution:** Check extension management page, ensure it's enabled

### Popups Still Appearing
- **Problem:** Popups on zoechip.com
- **Solutions:**
  1. Check console for error messages
  2. Verify site matches patterns in manifest
  3. Clear browser cache (Ctrl+Shift+Delete)
  4. Reload extension
  5. Disable conflicting extensions

### Video Not Playing
- **Problem:** Video player removed by mistake
- **Solutions:**
  1. Reload page (F5)
  2. Check console for "Removed suspicious overlay" messages
  3. If persistent, whitelist the site via extension popup

### Permission Errors
- **Problem:** Can't copy to Program Files
- **Solution:** Run Command Prompt as Administrator

### Console Shows No Messages
- **Problem:** No StreamShield messages in console
- **Solutions:**
  1. Verify extension is enabled
  2. Hard reload page (Ctrl+Shift+R)
  3. Check extension has host_permissions for <all_urls>

## Uninstall

### Remove Extension
1. Go to extension management page
2. Find "StreamShield - Ultimate Ad Blocker"
3. Click "Remove"
4. Confirm removal

### Clean Up (Optional)
If installed to Program Files:
```bash
# Run as Administrator
rmdir /s "C:\Program Files\StreamShield\extensions\chrome"
```

## Update Extension

### Manual Update
1. Download/pull latest version
2. Go to extension management page
3. Click reload icon next to StreamShield
4. Or remove and re-install

### Automatic Update (Future)
When published to Chrome Web Store, updates will be automatic.

## Configuration

### Access Settings
1. Click StreamShield icon in toolbar
2. Click settings gear icon
3. Adjust preferences:
   - Dark Mode
   - Ad Blocking
   - YouTube Features
   - Privacy Protection

### Whitelist a Site
1. Visit the site
2. Click StreamShield icon
3. Click "Whitelist this domain"
4. Page will reload with blocking disabled

### View Statistics
1. Click StreamShield icon
2. View blocked counts:
   - Ads blocked
   - Trackers blocked
   - Popups blocked
   - Overlays removed

## Integration with StreamShield Proxy

### Running Both (Recommended)
For maximum protection, run both extension AND proxy:

1. **Install Extension** (as above)
2. **Start Proxy:**
   ```bash
   python -m streamshield
   ```
3. **Configure Browser Proxy:**
   - HTTP Proxy: localhost:8080
4. **Visit Sites:**
   - Both layers will protect you
   - Extension handles client-side
   - Proxy handles network-level

### Benefits of Both
- Defense in depth (multiple layers)
- One catches what the other misses
- Proxy can block before page loads
- Extension can block after page loads

## Support

### Getting Help
1. Check browser console for errors
2. Review ZOECHIP_POPUP_FIX.md
3. Test with test-popup-blocker.html
4. Check extension is enabled and has permissions

### Reporting Issues
Include in bug reports:
- Browser version
- Site URL where issue occurred
- Console errors (F12)
- Steps to reproduce

## Advanced

### Development Mode
For developers:
1. Modify files in `E:\BETA!!!\AIAdblocking\extension\chrome\`
2. Reload extension in browser
3. Test changes
4. Check console for errors

### Add More Streaming Sites
Edit `manifest.json`:
```json
"matches": [
  "*://*.zoechip.com/*",
  "*://*.your-new-site.com/*"  // Add here
]
```

### Customize Blocking Rules
Edit `zoechip-popup-blocker.js`:
```javascript
const adPatterns = [
  'popads',
  'your-ad-network'  // Add here
];
```

## Privacy Notice

StreamShield:
- ✅ Runs locally (no cloud connection)
- ✅ No data collection
- ✅ No telemetry
- ✅ Open source
- ✅ Can run offline
- ⚠️ SponsorBlock requires internet (optional)

## License

MIT License - Free to use, modify, and distribute

---

**Version:** 3.0.0
**Last Updated:** 2025-12-06
**Status:** Production Ready
